/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.ReadException;
import com.quantumdata.sct.dao.exception.UpdateException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.Capabilities;
import com.quantumdata.sct.dao.jaxb.Commands;
import com.quantumdata.sct.dao.jaxb.Standard;
import com.quantumdata.sct.dao.jaxb.impl.AbstractCommandTypeImpl;
import com.quantumdata.sct.dao.jaxb.impl.CommandsTypeImpl;
import com.quantumdata.sct.dao.jaxb.impl.InstrumentCommandTypeImpl;
import com.quantumdata.sct.dao.vo.AbstractCommandVO;
import com.quantumdata.sct.dao.vo.InputCapabilityVO;
import com.quantumdata.sct.dao.vo.InstrumentCommandVO;
import com.quantumdata.sct.dao.vo.JavaCommandVO;
import com.quantumdata.sct.dao.vo.OptionCapabilityVO;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import java.util.Iterator;

public class CommandDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = null;

    public void readCallback() throws DAOException {
        try {
            Commands commands = (Commands)this.daoObject;
            int n = commands.getCommandsLength();
            this.daoCollection.clear();
            for (int i = 0; i < n; ++i) {
                AbstractCommandTypeImpl abstractCommandTypeImpl = (AbstractCommandTypeImpl)commands.getCommands(i);
                this.daoCollection.put(abstractCommandTypeImpl.getId(), new Integer(i));
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    private JavaCommandVO createJavaCommandVO(CommandsTypeImpl.JavaCommandImpl javaCommandImpl) throws Exception {
        JavaCommandVO javaCommandVO = new JavaCommandVO(javaCommandImpl.getClassName());
        this.copyFrom(javaCommandImpl, javaCommandVO);
        return javaCommandVO;
    }

    private InstrumentCommandVO createQueryCommandVO(CommandsTypeImpl.TEQueryImpl tEQueryImpl) throws Exception {
        InstrumentCommandVO instrumentCommandVO = new InstrumentCommandVO(2);
        instrumentCommandVO.setId(tEQueryImpl.getId());
        instrumentCommandVO.setLastUpdate(tEQueryImpl.getLastDateTime());
        instrumentCommandVO.setOpcode(tEQueryImpl.getOpCode());
        int n = tEQueryImpl.getParametersLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                AbstractCommandTypeImpl.ParameterImpl parameterImpl = (AbstractCommandTypeImpl.ParameterImpl)tEQueryImpl.getParameters(i);
                ParameterVO parameterVO = new ParameterVO();
                parameterVO.setName(parameterImpl.getName());
                parameterVO.setOutput(parameterImpl.isOutput());
                parameterVO.setRequired(parameterImpl.isRequired());
                parameterVO.setType(parameterImpl.getType());
                instrumentCommandVO.add(parameterVO);
            }
        }
        return instrumentCommandVO;
    }

    private InstrumentCommandVO createInstrumentCommandVO(CommandsTypeImpl.TECommandImpl tECommandImpl) throws Exception {
        InstrumentCommandVO instrumentCommandVO = new InstrumentCommandVO(1);
        this.copyFrom(tECommandImpl, instrumentCommandVO);
        return instrumentCommandVO;
    }

    private CommandsTypeImpl.TECommandImpl createInstrumentCommand(InstrumentCommandVO instrumentCommandVO) throws Exception {
        if (instrumentCommandVO.getType() != 1) {
            return null;
        }
        CommandsTypeImpl.TECommandImpl tECommandImpl = (CommandsTypeImpl.TECommandImpl)this.factory.createCommandsTypeTECommand();
        this.copyTo(tECommandImpl, instrumentCommandVO);
        return tECommandImpl;
    }

    private void copyFrom(CommandsTypeImpl.TECommandImpl tECommandImpl, InstrumentCommandVO instrumentCommandVO) throws Exception {
        instrumentCommandVO.setId(tECommandImpl.getId());
        instrumentCommandVO.setLastUpdate(tECommandImpl.getLastDateTime());
        instrumentCommandVO.setOpcode(tECommandImpl.getOpCode());
        int n = tECommandImpl.getParametersLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                AbstractCommandTypeImpl.ParameterImpl parameterImpl = (AbstractCommandTypeImpl.ParameterImpl)tECommandImpl.getParameters(i);
                ParameterVO parameterVO = new ParameterVO();
                parameterVO.setName(parameterImpl.getName());
                parameterVO.setOutput(parameterImpl.isOutput());
                parameterVO.setRequired(parameterImpl.isRequired());
                parameterVO.setType(parameterImpl.getType());
                parameterVO.setValue(parameterImpl.getValue());
                instrumentCommandVO.add(parameterVO);
            }
        }
    }

    private void copyTo(CommandsTypeImpl.TECommandImpl tECommandImpl, InstrumentCommandVO instrumentCommandVO) throws Exception {
        tECommandImpl.setId((String)instrumentCommandVO.getId());
        tECommandImpl.setLastDateTime(instrumentCommandVO.getLastUpdate());
        tECommandImpl.setOpCode(instrumentCommandVO.getOpcode());
        Iterator iterator = instrumentCommandVO.getParameters().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ParameterVO parameterVO = (ParameterVO)iterator.next();
            AbstractCommandTypeImpl.ParameterImpl parameterImpl = (AbstractCommandTypeImpl.ParameterImpl)this.factory.createCommandParameterType();
            parameterImpl.setName(parameterVO.getName());
            parameterImpl.setOutput(parameterVO.isOutput());
            parameterImpl.setRequired(parameterVO.isRequired());
            parameterImpl.setType(parameterVO.getType());
            parameterImpl.setValue(parameterVO.getValue());
            tECommandImpl.setParameters(n, parameterImpl);
            ++n;
        }
    }

    private void copyTo(CommandsTypeImpl.TEQueryImpl tEQueryImpl, InstrumentCommandVO instrumentCommandVO) throws Exception {
        tEQueryImpl.setId((String)instrumentCommandVO.getId());
        tEQueryImpl.setLastDateTime(instrumentCommandVO.getLastUpdate());
        tEQueryImpl.setOpCode(instrumentCommandVO.getOpcode());
        Iterator iterator = instrumentCommandVO.getParameters().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ParameterVO parameterVO = (ParameterVO)iterator.next();
            AbstractCommandTypeImpl.ParameterImpl parameterImpl = (AbstractCommandTypeImpl.ParameterImpl)this.factory.createCommandParameterType();
            parameterImpl.setName(parameterVO.getName());
            parameterImpl.setOutput(parameterVO.isOutput());
            parameterImpl.setRequired(parameterVO.isRequired());
            parameterImpl.setType(parameterVO.getType());
            parameterImpl.setValue(parameterVO.getValue());
            tEQueryImpl.setParameters(n, parameterImpl);
            ++n;
        }
    }

    private CommandsTypeImpl.TEQueryImpl createQueryCommand(InstrumentCommandVO instrumentCommandVO) throws Exception {
        if (instrumentCommandVO.getType() != 2) {
            return null;
        }
        CommandsTypeImpl.TEQueryImpl tEQueryImpl = (CommandsTypeImpl.TEQueryImpl)this.factory.createCommandsTypeTEQuery();
        this.copyTo(tEQueryImpl, instrumentCommandVO);
        return tEQueryImpl;
    }

    private void copyTo(CommandsTypeImpl.JavaCommandImpl javaCommandImpl, JavaCommandVO javaCommandVO) throws Exception {
        try {
            javaCommandImpl.setId((String)javaCommandVO.getId());
            javaCommandImpl.setLastDateTime(javaCommandVO.getLastUpdate());
            javaCommandImpl.setClassName(javaCommandVO.getClassName());
            Iterator iterator = javaCommandVO.getParameters().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ParameterVO parameterVO = (ParameterVO)iterator.next();
                AbstractCommandTypeImpl.ParameterImpl parameterImpl = (AbstractCommandTypeImpl.ParameterImpl)this.factory.createCommandParameterType();
                parameterImpl.setName(parameterVO.getName());
                parameterImpl.setOutput(parameterVO.isOutput());
                parameterImpl.setRequired(parameterVO.isRequired());
                parameterImpl.setType(parameterVO.getType());
                parameterImpl.setValue(parameterVO.getValue());
                javaCommandImpl.setParameters(n, parameterImpl);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private void copyFrom(CommandsTypeImpl.JavaCommandImpl javaCommandImpl, JavaCommandVO javaCommandVO) throws Exception {
        javaCommandVO.setId(javaCommandImpl.getId());
        javaCommandVO.setLastUpdate(javaCommandImpl.getLastDateTime());
        int n = javaCommandImpl.getParametersLength();
        for (int i = 0; i < n; ++i) {
            AbstractCommandTypeImpl.ParameterImpl parameterImpl = (AbstractCommandTypeImpl.ParameterImpl)javaCommandImpl.getParameters(i);
            ParameterVO parameterVO = new ParameterVO();
            parameterVO.setName(parameterImpl.getName());
            parameterVO.setType(parameterImpl.getType());
            parameterVO.setOutput(parameterImpl.isOutput());
            parameterVO.setRequired(parameterImpl.isRequired());
            parameterVO.setValue(parameterImpl.getValue());
            javaCommandVO.add(parameterVO);
        }
    }

    private CommandsTypeImpl.JavaCommandImpl createJavaCommand(JavaCommandVO javaCommandVO) throws Exception {
        CommandsTypeImpl.JavaCommandImpl javaCommandImpl = null;
        try {
            javaCommandImpl = (CommandsTypeImpl.JavaCommandImpl)this.factory.createCommandsTypeJavaCommand();
            this.copyTo(javaCommandImpl, javaCommandVO);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        return javaCommandImpl;
    }

    protected IPersistable getValueObjectForKey(Object object) throws CreateException {
        AbstractCommandVO abstractCommandVO;
        block6: {
            abstractCommandVO = null;
            try {
                int n = (Integer)this.daoCollection.get(object);
                int n2 = ((Commands)this.daoObject).getCommandsLength();
                if (n >= n2) {
                    throw new ArrayIndexOutOfBoundsException("Index out of bounds");
                }
                AbstractCommandTypeImpl abstractCommandTypeImpl = (AbstractCommandTypeImpl)((Commands)this.daoObject).getCommands(n);
                if (abstractCommandTypeImpl instanceof CommandsTypeImpl.TECommandImpl) {
                    abstractCommandVO = this.createInstrumentCommandVO((CommandsTypeImpl.TECommandImpl)abstractCommandTypeImpl);
                    break block6;
                }
                if (abstractCommandTypeImpl instanceof CommandsTypeImpl.JavaCommandImpl) {
                    abstractCommandVO = this.createJavaCommandVO((CommandsTypeImpl.JavaCommandImpl)abstractCommandTypeImpl);
                    break block6;
                }
                if (abstractCommandTypeImpl instanceof CommandsTypeImpl.TEQueryImpl) {
                    abstractCommandVO = this.createQueryCommandVO((CommandsTypeImpl.TEQueryImpl)abstractCommandTypeImpl);
                    break block6;
                }
                throw new InternalError("Invalid XML format or file");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new CreateException("Unable to fetch Command for key = " + object.toString(), null, exception);
            }
        }
        return abstractCommandVO;
    }

    public IPersistable[] findByAll() throws Exception {
        int n = ((CommandsTypeImpl)this.daoObject).getCommandsLength();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            AbstractCommandTypeImpl abstractCommandTypeImpl = (AbstractCommandTypeImpl)((Commands)this.daoObject).getCommands(i);
            iPersistableArray[i] = this.createPersistable(abstractCommandTypeImpl);
        }
        return iPersistableArray;
    }

    public Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof Standard) {
            Standard standard = (Standard)object;
            object2 = standard.getId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    public final IPersistable createPersistable(Object object) {
        AbstractCommandVO abstractCommandVO = null;
        try {
            if (object instanceof CommandsTypeImpl.JavaCommandImpl) {
                abstractCommandVO = this.createJavaCommandVO((CommandsTypeImpl.JavaCommandImpl)object);
            } else if (object instanceof CommandsTypeImpl.TEQueryImpl) {
                abstractCommandVO = this.createQueryCommandVO((CommandsTypeImpl.TEQueryImpl)object);
            } else if (object instanceof CommandsTypeImpl.TECommandImpl) {
                abstractCommandVO = this.createInstrumentCommandVO((CommandsTypeImpl.TECommandImpl)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return abstractCommandVO;
    }

    public final void update(IPersistable iPersistable) throws UpdateException {
        if (iPersistable instanceof InputCapabilityVO) {
            this.update((InputCapabilityVO)iPersistable);
        } else if (iPersistable instanceof OptionCapabilityVO) {
            this.update((OptionCapabilityVO)iPersistable);
        }
    }

    protected void updateObject(IPersistable iPersistable) {
        try {
            if (iPersistable instanceof InputCapabilityVO) {
                this.update((InputCapabilityVO)iPersistable);
            } else if (iPersistable instanceof OptionCapabilityVO) {
                this.update((OptionCapabilityVO)iPersistable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected final IPersistable findByPrimaryKey(String string) throws ReadException {
        IPersistable iPersistable = null;
        try {
            if (this.daoCollection.containsKey(string)) {
                Integer n = (Integer)this.daoCollection.get(string);
                Object e = ((Capabilities)this.daoObject).getCollection().get(n);
                iPersistable = this.createPersistable(e);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ReadException(exception.getMessage());
        }
        return iPersistable;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                int n = (Integer)this.daoCollection.get(object);
                ((Capabilities)this.daoObject).getCollection().remove(n);
                this.flush();
                this.initialize(this._ctx);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public void add(IPersistable iPersistable) throws CreateException {
        try {
            if (iPersistable instanceof JavaCommandVO) {
                CommandsTypeImpl.JavaCommandImpl javaCommandImpl = this.createJavaCommand((JavaCommandVO)iPersistable);
                ((Capabilities)this.daoObject).getCollection().add(javaCommandImpl);
            } else if (iPersistable instanceof InstrumentCommandVO) {
                InstrumentCommandTypeImpl instrumentCommandTypeImpl = null;
                instrumentCommandTypeImpl = ((InstrumentCommandVO)iPersistable).getType() == 1 ? this.createInstrumentCommand((InstrumentCommandVO)iPersistable) : this.createQueryCommand((InstrumentCommandVO)iPersistable);
                ((Capabilities)this.daoObject).getCollection().add(instrumentCommandTypeImpl);
                this.flush();
                this.readCallback();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CreateException("Unable to insert VO object", null, exception);
        }
    }

    public AbstractCommandTypeImpl create(IPersistable iPersistable) throws Exception {
        AbstractCommandTypeImpl abstractCommandTypeImpl = null;
        if (iPersistable instanceof JavaCommandVO) {
            abstractCommandTypeImpl = this.createJavaCommand((JavaCommandVO)iPersistable);
        } else if (iPersistable instanceof InstrumentCommandVO) {
            if (((InstrumentCommandVO)iPersistable).getType() == 1) {
                abstractCommandTypeImpl = this.createInstrumentCommand((InstrumentCommandVO)iPersistable);
            } else if (((InstrumentCommandVO)iPersistable).getType() == 2) {
                abstractCommandTypeImpl = this.createInstrumentCommand((InstrumentCommandVO)iPersistable);
            }
        } else {
            throw new Exception("Invalid Value Object");
        }
        return abstractCommandTypeImpl;
    }

    public void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            AbstractCommandTypeImpl abstractCommandTypeImpl = this.create(iPersistable);
            ((Commands)this.daoObject).setCommands(n, abstractCommandTypeImpl);
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CreateException("Unable to insert VO object", null, exception);
        }
    }
}

